<?php

/**
 * Class that operate on table 'productunit'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ProductunitMySqlDAO implements ProductunitDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductunitMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productunit WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productunit';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productunit ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productunit primary key
     */
    public function delete($productunitid) {
        $sql = 'DELETE FROM productunit WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productunitid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductunitMySql productunit
     */
    public function insert($productunit) {
        $sql = 'INSERT INTO productunit (unitid, productid, productnumber, productunitdate, userid, conditions,proUnitParcode,proUnitSellAllPrice,proUnitSellHalfPrice,proUnitSellUnitPrice,proUnitBuyPrice,unitInTax,proUnitPrice4,proUnitPrice5,proUnitPrice6,proUnitPrice7,proUnitPrice8,proUnitPrice9,proUnitPrice10,proUnitPrice11,proUnitPrice12,proUnitPrice13) VALUES (?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productunit->unitid);
        $sqlQuery->setNumber($productunit->productid);
        $sqlQuery->setNumber($productunit->productnumber);
        $sqlQuery->set($productunit->productunitdate);
        $sqlQuery->setNumber($productunit->userid);
        $sqlQuery->setNumber($productunit->conditions);
        $sqlQuery->set($productunit->proUnitParcode);
        $sqlQuery->setNumber((float) $productunit->proUnitSellAllPrice);
        $sqlQuery->setNumber((float) $productunit->proUnitSellHalfPrice);
        $sqlQuery->setNumber((float) $productunit->proUnitSellUnitPrice);
        $sqlQuery->setNumber((float) $productunit->proUnitBuyPrice);
        $sqlQuery->set($productunit->unitInTax);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice4);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice5);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice6);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice7);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice8);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice9);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice10);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice11);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice12);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice13);

        $id = $this->executeInsert($sqlQuery);
        $productunit->productunitid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductunitMySql productunit
     */
    public function update($productunit) {
        $sql = 'UPDATE productunit SET unitid = ?, productid = ?, productnumber = ?, productunitdate = ?, userid = ?, conditions = ?,proUnitParcode=?,proUnitSellAllPrice=?,proUnitSellHalfPrice=?,proUnitSellUnitPrice =?,proUnitBuyPrice=?,unitInTax=?,proUnitPrice4=?,proUnitPrice5=?,proUnitPrice6=?,proUnitPrice7=?,proUnitPrice8=?,proUnitPrice9=?,proUnitPrice10=?,proUnitPrice11=?,proUnitPrice12=?,proUnitPrice13=? WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productunit->unitid);
        $sqlQuery->setNumber($productunit->productid);
        $sqlQuery->setNumber($productunit->productnumber);
        $sqlQuery->set($productunit->productunitdate);
        $sqlQuery->setNumber($productunit->userid);
        $sqlQuery->setNumber($productunit->conditions);
        $sqlQuery->set($productunit->proUnitParcode);
        $sqlQuery->setNumber((float) $productunit->proUnitSellAllPrice);
        $sqlQuery->setNumber((float) $productunit->proUnitSellHalfPrice);
        $sqlQuery->setNumber((float) $productunit->proUnitSellUnitPrice);
        $sqlQuery->setNumber((float) $productunit->proUnitBuyPrice);
        $sqlQuery->set($productunit->unitInTax);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice4);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice5);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice6);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice7);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice8);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice9);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice10);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice11);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice12);
        $sqlQuery->setNumber((float) $productunit->proUnitPrice13);

        $sqlQuery->setNumber($productunit->productunitid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productunit';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByUnitid($value) {
        $sql = 'SELECT * FROM productunit WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productunit WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductnumber($value) {
        $sql = 'SELECT * FROM productunit WHERE productnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductunitdate($value) {
        $sql = 'SELECT * FROM productunit WHERE productunitdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM productunit WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM productunit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByUnitid($value) {
        $sql = 'DELETE FROM productunit WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productunit WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductnumber($value) {
        $sql = 'DELETE FROM productunit WHERE productnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductunitdate($value) {
        $sql = 'DELETE FROM productunit WHERE productunitdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM productunit WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM productunit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductunitMySql
     */
    protected function readRow($row) {
        $productunit = new Productunit();

        $productunit->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $productunit->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $productunit->productid = isset($row['productid']) ? $row['productid'] : '';
        $productunit->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';
        $productunit->productunitdate = isset($row['productunitdate']) ? $row['productunitdate'] : '';
        $productunit->userid = isset($row['userid']) ? $row['userid'] : '';
        $productunit->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $productunit->overAllAveragePrice = isset($row['overAllAveragePrice']) ? $row['overAllAveragePrice'] : '';
        $productunit->proUnitParcode = isset($row['proUnitParcode']) ? $row['proUnitParcode'] : '';
        $productunit->proUnitSellAllPrice = isset($row['proUnitSellAllPrice']) ? $row['proUnitSellAllPrice'] : '';
        $productunit->proUnitSellHalfPrice = isset($row['proUnitSellHalfPrice']) ? $row['proUnitSellHalfPrice'] : '';
        $productunit->proUnitSellUnitPrice = isset($row['proUnitSellUnitPrice']) ? $row['proUnitSellUnitPrice'] : '';
        $productunit->proUnitBuyPrice = isset($row['proUnitBuyPrice']) ? $row['proUnitBuyPrice'] : '';
        $productunit->unitInTax = isset($row['unitInTax']) ? $row['unitInTax'] : '';
        $productunit->proUnitPrice4 = isset($row['proUnitPrice4']) ? $row['proUnitPrice4'] : '';
        $productunit->proUnitPrice5 = isset($row['proUnitPrice5']) ? $row['proUnitPrice5'] : '';
        $productunit->proUnitPrice6 = isset($row['proUnitPrice6']) ? $row['proUnitPrice6'] : '';
        $productunit->proUnitPrice7 = isset($row['proUnitPrice7']) ? $row['proUnitPrice7'] : '';
        $productunit->proUnitPrice8 = isset($row['proUnitPrice8']) ? $row['proUnitPrice8'] : '';
        $productunit->proUnitPrice9 = isset($row['proUnitPrice9']) ? $row['proUnitPrice9'] : '';
        $productunit->proUnitPrice10 = isset($row['proUnitPrice10']) ? $row['proUnitPrice10'] : '';
        $productunit->proUnitPrice11 = isset($row['proUnitPrice11']) ? $row['proUnitPrice11'] : '';
        $productunit->proUnitPrice12 = isset($row['proUnitPrice12']) ? $row['proUnitPrice12'] : '';
        $productunit->proUnitPrice13 = isset($row['proUnitPrice13']) ? $row['proUnitPrice13'] : '';

        //required
        $productunit->unitName = isset($row['unitName']) ? $row['unitName'] : '';

        return $productunit;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductunitMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>